package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ValidationTokenHost {
  def unwrap
      : software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost
}
object ValidationTokenHost {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost
  ): zio.aws.cloudfront.model.ValidationTokenHost = value match {
    case software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost.CLOUDFRONT =>
      val r = cloudfront
      r
    case software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost.SELF_HOSTED =>
      val r = `self-hosted`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ValidationTokenHost {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost =
      software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost.UNKNOWN_TO_SDK_VERSION
  }
  case object cloudfront extends zio.aws.cloudfront.model.ValidationTokenHost {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost =
      software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost.CLOUDFRONT
  }
  case object `self-hosted`
      extends zio.aws.cloudfront.model.ValidationTokenHost {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost =
      software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost.SELF_HOSTED
  }
}
