package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDomainAssociationResponse(
    domain: Optional[String] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationResponse = {
    import UpdateDomainAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationResponse
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateDomainAssociationResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateDomainAssociationResponse
      .wrap(buildAwsValue())
}
object UpdateDomainAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateDomainAssociationResponse =
      zio.aws.cloudfront.model.UpdateDomainAssociationResponse(
        domain.map(value => value),
        resourceId.map(value => value),
        eTag.map(value => value)
      )
    def domain: Optional[String]
    def resourceId: Optional[String]
    def eTag: Optional[String]
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationResponse
  ) extends zio.aws.cloudfront.model.UpdateDomainAssociationResponse.ReadOnly {
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationResponse
  ): zio.aws.cloudfront.model.UpdateDomainAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
