package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDistributionTenantRequest(
    id: String,
    distributionId: Optional[String] = Optional.Absent,
    domains: Optional[Iterable[zio.aws.cloudfront.model.DomainItem]] =
      Optional.Absent,
    customizations: Optional[zio.aws.cloudfront.model.Customizations] =
      Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudfront.model.Parameter]] =
      Optional.Absent,
    connectionGroupId: Optional[String] = Optional.Absent,
    ifMatch: String,
    managedCertificateRequest: Optional[
      zio.aws.cloudfront.model.ManagedCertificateRequest
    ] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantRequest = {
    import UpdateDistributionTenantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(distributionId.map(value => value: java.lang.String))(
        _.distributionId
      )
      .optionallyWith(
        domains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domains)
      .optionallyWith(customizations.map(value => value.buildAwsValue()))(
        _.customizations
      )
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(connectionGroupId.map(value => value: java.lang.String))(
        _.connectionGroupId
      )
      .ifMatch(ifMatch: java.lang.String)
      .optionallyWith(
        managedCertificateRequest.map(value => value.buildAwsValue())
      )(_.managedCertificateRequest)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateDistributionTenantRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateDistributionTenantRequest
      .wrap(buildAwsValue())
}
object UpdateDistributionTenantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateDistributionTenantRequest =
      zio.aws.cloudfront.model.UpdateDistributionTenantRequest(
        id,
        distributionId.map(value => value),
        domains.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customizations.map(value => value.asEditable),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        connectionGroupId.map(value => value),
        ifMatch,
        managedCertificateRequest.map(value => value.asEditable),
        enabled.map(value => value)
      )
    def id: String
    def distributionId: Optional[String]
    def domains: Optional[List[zio.aws.cloudfront.model.DomainItem.ReadOnly]]
    def customizations
        : Optional[zio.aws.cloudfront.model.Customizations.ReadOnly]
    def parameters: Optional[List[zio.aws.cloudfront.model.Parameter.ReadOnly]]
    def connectionGroupId: Optional[String]
    def ifMatch: String
    def managedCertificateRequest
        : Optional[zio.aws.cloudfront.model.ManagedCertificateRequest.ReadOnly]
    def enabled: Optional[Boolean]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getDistributionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("distributionId", distributionId)
    def getDomains: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.DomainItem.ReadOnly
    ]] = AwsError.unwrapOptionField("domains", domains)
    def getCustomizations
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Customizations.ReadOnly] =
      AwsError.unwrapOptionField("customizations", customizations)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getConnectionGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionGroupId", connectionGroupId)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
    def getManagedCertificateRequest: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ManagedCertificateRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "managedCertificateRequest",
      managedCertificateRequest
    )
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantRequest
  ) extends zio.aws.cloudfront.model.UpdateDistributionTenantRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val distributionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionId())
      .map(value => value: String)
    override val domains
        : Optional[List[zio.aws.cloudfront.model.DomainItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.DomainItem.wrap(item)
          }.toList
        )
    override val customizations
        : Optional[zio.aws.cloudfront.model.Customizations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizations())
        .map(value => zio.aws.cloudfront.model.Customizations.wrap(value))
    override val parameters
        : Optional[List[zio.aws.cloudfront.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.Parameter.wrap(item)
          }.toList
        )
    override val connectionGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionGroupId())
      .map(value => value: String)
    override val ifMatch: String = impl.ifMatch(): String
    override val managedCertificateRequest: Optional[
      zio.aws.cloudfront.model.ManagedCertificateRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.managedCertificateRequest())
      .map(value =>
        zio.aws.cloudfront.model.ManagedCertificateRequest.wrap(value)
      )
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantRequest
  ): zio.aws.cloudfront.model.UpdateDistributionTenantRequest.ReadOnly =
    new Wrapper(impl)
}
