package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManagedCertificateRequest(
    validationTokenHost: zio.aws.cloudfront.model.ValidationTokenHost,
    primaryDomainName: Optional[String] = Optional.Absent,
    certificateTransparencyLoggingPreference: Optional[
      zio.aws.cloudfront.model.CertificateTransparencyLoggingPreference
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateRequest = {
    import ManagedCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ManagedCertificateRequest
      .builder()
      .validationTokenHost(validationTokenHost.unwrap)
      .optionallyWith(primaryDomainName.map(value => value: java.lang.String))(
        _.primaryDomainName
      )
      .optionallyWith(
        certificateTransparencyLoggingPreference.map(value => value.unwrap)
      )(_.certificateTransparencyLoggingPreference)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ManagedCertificateRequest.ReadOnly =
    zio.aws.cloudfront.model.ManagedCertificateRequest.wrap(buildAwsValue())
}
object ManagedCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ManagedCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ManagedCertificateRequest =
      zio.aws.cloudfront.model.ManagedCertificateRequest(
        validationTokenHost,
        primaryDomainName.map(value => value),
        certificateTransparencyLoggingPreference.map(value => value)
      )
    def validationTokenHost: zio.aws.cloudfront.model.ValidationTokenHost
    def primaryDomainName: Optional[String]
    def certificateTransparencyLoggingPreference: Optional[
      zio.aws.cloudfront.model.CertificateTransparencyLoggingPreference
    ]
    def getValidationTokenHost
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.ValidationTokenHost] =
      ZIO.succeed(validationTokenHost)
    def getPrimaryDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryDomainName", primaryDomainName)
    def getCertificateTransparencyLoggingPreference: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CertificateTransparencyLoggingPreference
    ] = AwsError.unwrapOptionField(
      "certificateTransparencyLoggingPreference",
      certificateTransparencyLoggingPreference
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ManagedCertificateRequest
  ) extends zio.aws.cloudfront.model.ManagedCertificateRequest.ReadOnly {
    override val validationTokenHost
        : zio.aws.cloudfront.model.ValidationTokenHost =
      zio.aws.cloudfront.model.ValidationTokenHost
        .wrap(impl.validationTokenHost())
    override val primaryDomainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.primaryDomainName())
      .map(value => value: String)
    override val certificateTransparencyLoggingPreference: Optional[
      zio.aws.cloudfront.model.CertificateTransparencyLoggingPreference
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateTransparencyLoggingPreference())
      .map(value =>
        zio.aws.cloudfront.model.CertificateTransparencyLoggingPreference
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ManagedCertificateRequest
  ): zio.aws.cloudfront.model.ManagedCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
