package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManagedCertificateDetails(
    certificateArn: Optional[String] = Optional.Absent,
    certificateStatus: Optional[
      zio.aws.cloudfront.model.ManagedCertificateStatus
    ] = Optional.Absent,
    validationTokenHost: Optional[
      zio.aws.cloudfront.model.ValidationTokenHost
    ] = Optional.Absent,
    validationTokenDetails: Optional[
      Iterable[zio.aws.cloudfront.model.ValidationTokenDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateDetails = {
    import ManagedCertificateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ManagedCertificateDetails
      .builder()
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(certificateStatus.map(value => value.unwrap))(
        _.certificateStatus
      )
      .optionallyWith(validationTokenHost.map(value => value.unwrap))(
        _.validationTokenHost
      )
      .optionallyWith(
        validationTokenDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationTokenDetails)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ManagedCertificateDetails.ReadOnly =
    zio.aws.cloudfront.model.ManagedCertificateDetails.wrap(buildAwsValue())
}
object ManagedCertificateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ManagedCertificateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ManagedCertificateDetails =
      zio.aws.cloudfront.model.ManagedCertificateDetails(
        certificateArn.map(value => value),
        certificateStatus.map(value => value),
        validationTokenHost.map(value => value),
        validationTokenDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificateArn: Optional[String]
    def certificateStatus
        : Optional[zio.aws.cloudfront.model.ManagedCertificateStatus]
    def validationTokenHost
        : Optional[zio.aws.cloudfront.model.ValidationTokenHost]
    def validationTokenDetails: Optional[
      List[zio.aws.cloudfront.model.ValidationTokenDetail.ReadOnly]
    ]
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ManagedCertificateStatus
    ] = AwsError.unwrapOptionField("certificateStatus", certificateStatus)
    def getValidationTokenHost
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.ValidationTokenHost] =
      AwsError.unwrapOptionField("validationTokenHost", validationTokenHost)
    def getValidationTokenDetails: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.ValidationTokenDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "validationTokenDetails",
      validationTokenDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ManagedCertificateDetails
  ) extends zio.aws.cloudfront.model.ManagedCertificateDetails.ReadOnly {
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val certificateStatus
        : Optional[zio.aws.cloudfront.model.ManagedCertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateStatus())
        .map(value =>
          zio.aws.cloudfront.model.ManagedCertificateStatus.wrap(value)
        )
    override val validationTokenHost
        : Optional[zio.aws.cloudfront.model.ValidationTokenHost] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationTokenHost())
        .map(value => zio.aws.cloudfront.model.ValidationTokenHost.wrap(value))
    override val validationTokenDetails: Optional[
      List[zio.aws.cloudfront.model.ValidationTokenDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validationTokenDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.ValidationTokenDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ManagedCertificateDetails
  ): zio.aws.cloudfront.model.ManagedCertificateDetails.ReadOnly = new Wrapper(
    impl
  )
}
