package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInvalidationsForDistributionTenantRequest(
    id: String,
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantRequest = {
    import ListInvalidationsForDistributionTenantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.Integer))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantRequest.ReadOnly =
    zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantRequest
      .wrap(buildAwsValue())
}
object ListInvalidationsForDistributionTenantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantRequest =
      zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantRequest(
        id,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def id: String
    def marker: Optional[String]
    def maxItems: Optional[Integer]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantRequest
  ) extends zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantRequest
  ): zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantRequest.ReadOnly =
    new Wrapper(impl)
}
