package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionTenantsByCustomizationRequest(
    webACLArn: Optional[String] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsByCustomizationRequest = {
    import ListDistributionTenantsByCustomizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsByCustomizationRequest
      .builder()
      .optionallyWith(webACLArn.map(value => value: java.lang.String))(
        _.webACLArn
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.Integer))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionTenantsByCustomizationRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionTenantsByCustomizationRequest
      .wrap(buildAwsValue())
}
object ListDistributionTenantsByCustomizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsByCustomizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionTenantsByCustomizationRequest =
      zio.aws.cloudfront.model.ListDistributionTenantsByCustomizationRequest(
        webACLArn.map(value => value),
        certificateArn.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def webACLArn: Optional[String]
    def certificateArn: Optional[String]
    def marker: Optional[String]
    def maxItems: Optional[Integer]
    def getWebACLArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("webACLArn", webACLArn)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsByCustomizationRequest
  ) extends zio.aws.cloudfront.model.ListDistributionTenantsByCustomizationRequest.ReadOnly {
    override val webACLArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.webACLArn())
      .map(value => value: String)
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsByCustomizationRequest
  ): zio.aws.cloudfront.model.ListDistributionTenantsByCustomizationRequest.ReadOnly =
    new Wrapper(impl)
}
