package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInvalidationForDistributionTenantResponse(
    invalidation: Optional[zio.aws.cloudfront.model.Invalidation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantResponse = {
    import GetInvalidationForDistributionTenantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantResponse
      .builder()
      .optionallyWith(invalidation.map(value => value.buildAwsValue()))(
        _.invalidation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetInvalidationForDistributionTenantResponse.ReadOnly =
    zio.aws.cloudfront.model.GetInvalidationForDistributionTenantResponse
      .wrap(buildAwsValue())
}
object GetInvalidationForDistributionTenantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetInvalidationForDistributionTenantResponse =
      zio.aws.cloudfront.model.GetInvalidationForDistributionTenantResponse(
        invalidation.map(value => value.asEditable)
      )
    def invalidation: Optional[zio.aws.cloudfront.model.Invalidation.ReadOnly]
    def getInvalidation
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Invalidation.ReadOnly] =
      AwsError.unwrapOptionField("invalidation", invalidation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantResponse
  ) extends zio.aws.cloudfront.model.GetInvalidationForDistributionTenantResponse.ReadOnly {
    override val invalidation
        : Optional[zio.aws.cloudfront.model.Invalidation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidation())
        .map(value => zio.aws.cloudfront.model.Invalidation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantResponse
  ): zio.aws.cloudfront.model.GetInvalidationForDistributionTenantResponse.ReadOnly =
    new Wrapper(impl)
}
