package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DistributionSummary(
    id: String,
    arn: String,
    eTag: Optional[String] = Optional.Absent,
    status: String,
    lastModifiedTime: Timestamp,
    domainName: String,
    aliases: zio.aws.cloudfront.model.Aliases,
    origins: zio.aws.cloudfront.model.Origins,
    originGroups: Optional[zio.aws.cloudfront.model.OriginGroups] =
      Optional.Absent,
    defaultCacheBehavior: zio.aws.cloudfront.model.DefaultCacheBehavior,
    cacheBehaviors: zio.aws.cloudfront.model.CacheBehaviors,
    customErrorResponses: zio.aws.cloudfront.model.CustomErrorResponses,
    comment: String,
    priceClass: zio.aws.cloudfront.model.PriceClass,
    enabled: Boolean,
    viewerCertificate: zio.aws.cloudfront.model.ViewerCertificate,
    restrictions: zio.aws.cloudfront.model.Restrictions,
    webACLId: String,
    httpVersion: zio.aws.cloudfront.model.HttpVersion,
    isIPV6Enabled: Boolean,
    aliasICPRecordals: Optional[
      Iterable[zio.aws.cloudfront.model.AliasICPRecordal]
    ] = Optional.Absent,
    staging: Boolean,
    connectionMode: Optional[zio.aws.cloudfront.model.ConnectionMode] =
      Optional.Absent,
    anycastIpListId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DistributionSummary = {
    import DistributionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DistributionSummary
      .builder()
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .status(status: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .domainName(domainName: java.lang.String)
      .aliases(aliases.buildAwsValue())
      .origins(origins.buildAwsValue())
      .optionallyWith(originGroups.map(value => value.buildAwsValue()))(
        _.originGroups
      )
      .defaultCacheBehavior(defaultCacheBehavior.buildAwsValue())
      .cacheBehaviors(cacheBehaviors.buildAwsValue())
      .customErrorResponses(customErrorResponses.buildAwsValue())
      .comment(comment: java.lang.String)
      .priceClass(priceClass.unwrap)
      .enabled(enabled: java.lang.Boolean)
      .viewerCertificate(viewerCertificate.buildAwsValue())
      .restrictions(restrictions.buildAwsValue())
      .webACLId(webACLId: java.lang.String)
      .httpVersion(httpVersion.unwrap)
      .isIPV6Enabled(isIPV6Enabled: java.lang.Boolean)
      .optionallyWith(
        aliasICPRecordals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliasICPRecordals)
      .staging(staging: java.lang.Boolean)
      .optionallyWith(connectionMode.map(value => value.unwrap))(
        _.connectionMode
      )
      .optionallyWith(anycastIpListId.map(value => value: java.lang.String))(
        _.anycastIpListId
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DistributionSummary.ReadOnly =
    zio.aws.cloudfront.model.DistributionSummary.wrap(buildAwsValue())
}
object DistributionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DistributionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DistributionSummary =
      zio.aws.cloudfront.model.DistributionSummary(
        id,
        arn,
        eTag.map(value => value),
        status,
        lastModifiedTime,
        domainName,
        aliases.asEditable,
        origins.asEditable,
        originGroups.map(value => value.asEditable),
        defaultCacheBehavior.asEditable,
        cacheBehaviors.asEditable,
        customErrorResponses.asEditable,
        comment,
        priceClass,
        enabled,
        viewerCertificate.asEditable,
        restrictions.asEditable,
        webACLId,
        httpVersion,
        isIPV6Enabled,
        aliasICPRecordals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        staging,
        connectionMode.map(value => value),
        anycastIpListId.map(value => value)
      )
    def id: String
    def arn: String
    def eTag: Optional[String]
    def status: String
    def lastModifiedTime: Timestamp
    def domainName: String
    def aliases: zio.aws.cloudfront.model.Aliases.ReadOnly
    def origins: zio.aws.cloudfront.model.Origins.ReadOnly
    def originGroups: Optional[zio.aws.cloudfront.model.OriginGroups.ReadOnly]
    def defaultCacheBehavior
        : zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly
    def cacheBehaviors: zio.aws.cloudfront.model.CacheBehaviors.ReadOnly
    def customErrorResponses
        : zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly
    def comment: String
    def priceClass: zio.aws.cloudfront.model.PriceClass
    def enabled: Boolean
    def viewerCertificate: zio.aws.cloudfront.model.ViewerCertificate.ReadOnly
    def restrictions: zio.aws.cloudfront.model.Restrictions.ReadOnly
    def webACLId: String
    def httpVersion: zio.aws.cloudfront.model.HttpVersion
    def isIPV6Enabled: Boolean
    def aliasICPRecordals
        : Optional[List[zio.aws.cloudfront.model.AliasICPRecordal.ReadOnly]]
    def staging: Boolean
    def connectionMode: Optional[zio.aws.cloudfront.model.ConnectionMode]
    def anycastIpListId: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getAliases
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.Aliases.ReadOnly] =
      ZIO.succeed(aliases)
    def getOrigins
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.Origins.ReadOnly] =
      ZIO.succeed(origins)
    def getOriginGroups
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.OriginGroups.ReadOnly] =
      AwsError.unwrapOptionField("originGroups", originGroups)
    def getDefaultCacheBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly
    ] = ZIO.succeed(defaultCacheBehavior)
    def getCacheBehaviors
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.CacheBehaviors.ReadOnly] =
      ZIO.succeed(cacheBehaviors)
    def getCustomErrorResponses: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly
    ] = ZIO.succeed(customErrorResponses)
    def getComment: ZIO[Any, Nothing, String] = ZIO.succeed(comment)
    def getPriceClass: ZIO[Any, Nothing, zio.aws.cloudfront.model.PriceClass] =
      ZIO.succeed(priceClass)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getViewerCertificate: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ViewerCertificate.ReadOnly
    ] = ZIO.succeed(viewerCertificate)
    def getRestrictions
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.Restrictions.ReadOnly] =
      ZIO.succeed(restrictions)
    def getWebACLId: ZIO[Any, Nothing, String] = ZIO.succeed(webACLId)
    def getHttpVersion
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.HttpVersion] =
      ZIO.succeed(httpVersion)
    def getIsIPV6Enabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(isIPV6Enabled)
    def getAliasICPRecordals: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.AliasICPRecordal.ReadOnly
    ]] = AwsError.unwrapOptionField("aliasICPRecordals", aliasICPRecordals)
    def getStaging: ZIO[Any, Nothing, Boolean] = ZIO.succeed(staging)
    def getConnectionMode
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.ConnectionMode] =
      AwsError.unwrapOptionField("connectionMode", connectionMode)
    def getAnycastIpListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("anycastIpListId", anycastIpListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionSummary
  ) extends zio.aws.cloudfront.model.DistributionSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
    override val status: String = impl.status(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val domainName: String = impl.domainName(): String
    override val aliases: zio.aws.cloudfront.model.Aliases.ReadOnly =
      zio.aws.cloudfront.model.Aliases.wrap(impl.aliases())
    override val origins: zio.aws.cloudfront.model.Origins.ReadOnly =
      zio.aws.cloudfront.model.Origins.wrap(impl.origins())
    override val originGroups
        : Optional[zio.aws.cloudfront.model.OriginGroups.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originGroups())
        .map(value => zio.aws.cloudfront.model.OriginGroups.wrap(value))
    override val defaultCacheBehavior
        : zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly =
      zio.aws.cloudfront.model.DefaultCacheBehavior
        .wrap(impl.defaultCacheBehavior())
    override val cacheBehaviors
        : zio.aws.cloudfront.model.CacheBehaviors.ReadOnly =
      zio.aws.cloudfront.model.CacheBehaviors.wrap(impl.cacheBehaviors())
    override val customErrorResponses
        : zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly =
      zio.aws.cloudfront.model.CustomErrorResponses
        .wrap(impl.customErrorResponses())
    override val comment: String = impl.comment(): String
    override val priceClass: zio.aws.cloudfront.model.PriceClass =
      zio.aws.cloudfront.model.PriceClass.wrap(impl.priceClass())
    override val enabled: Boolean = impl.enabled(): Boolean
    override val viewerCertificate
        : zio.aws.cloudfront.model.ViewerCertificate.ReadOnly =
      zio.aws.cloudfront.model.ViewerCertificate.wrap(impl.viewerCertificate())
    override val restrictions: zio.aws.cloudfront.model.Restrictions.ReadOnly =
      zio.aws.cloudfront.model.Restrictions.wrap(impl.restrictions())
    override val webACLId: String = impl.webACLId(): String
    override val httpVersion: zio.aws.cloudfront.model.HttpVersion =
      zio.aws.cloudfront.model.HttpVersion.wrap(impl.httpVersion())
    override val isIPV6Enabled: Boolean = impl.isIPV6Enabled(): Boolean
    override val aliasICPRecordals
        : Optional[List[zio.aws.cloudfront.model.AliasICPRecordal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliasICPRecordals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.AliasICPRecordal.wrap(item)
          }.toList
        )
    override val staging: Boolean = impl.staging(): Boolean
    override val connectionMode
        : Optional[zio.aws.cloudfront.model.ConnectionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionMode())
        .map(value => zio.aws.cloudfront.model.ConnectionMode.wrap(value))
    override val anycastIpListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.anycastIpListId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionSummary
  ): zio.aws.cloudfront.model.DistributionSummary.ReadOnly = new Wrapper(impl)
}
