package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateConnectionGroupRequest(
    name: String,
    ipv6Enabled: Optional[Boolean] = Optional.Absent,
    tags: Optional[zio.aws.cloudfront.model.Tags] = Optional.Absent,
    anycastIpListId: Optional[String] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateConnectionGroupRequest = {
    import CreateConnectionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateConnectionGroupRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(ipv6Enabled.map(value => value: java.lang.Boolean))(
        _.ipv6Enabled
      )
      .optionallyWith(tags.map(value => value.buildAwsValue()))(_.tags)
      .optionallyWith(anycastIpListId.map(value => value: java.lang.String))(
        _.anycastIpListId
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateConnectionGroupRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateConnectionGroupRequest.wrap(buildAwsValue())
}
object CreateConnectionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateConnectionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateConnectionGroupRequest =
      zio.aws.cloudfront.model.CreateConnectionGroupRequest(
        name,
        ipv6Enabled.map(value => value),
        tags.map(value => value.asEditable),
        anycastIpListId.map(value => value),
        enabled.map(value => value)
      )
    def name: String
    def ipv6Enabled: Optional[Boolean]
    def tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly]
    def anycastIpListId: Optional[String]
    def enabled: Optional[Boolean]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getIpv6Enabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Enabled", ipv6Enabled)
    def getTags: ZIO[Any, AwsError, zio.aws.cloudfront.model.Tags.ReadOnly] =
      AwsError.unwrapOptionField("tags", tags)
    def getAnycastIpListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("anycastIpListId", anycastIpListId)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateConnectionGroupRequest
  ) extends zio.aws.cloudfront.model.CreateConnectionGroupRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val ipv6Enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Enabled())
      .map(value => value: Boolean)
    override val tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value => zio.aws.cloudfront.model.Tags.wrap(value))
    override val anycastIpListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.anycastIpListId())
      .map(value => value: String)
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateConnectionGroupRequest
  ): zio.aws.cloudfront.model.CreateConnectionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
