package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectionGroupAssociationFilter(
    anycastIpListId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ConnectionGroupAssociationFilter = {
    import ConnectionGroupAssociationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ConnectionGroupAssociationFilter
      .builder()
      .optionallyWith(anycastIpListId.map(value => value: java.lang.String))(
        _.anycastIpListId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ConnectionGroupAssociationFilter.ReadOnly =
    zio.aws.cloudfront.model.ConnectionGroupAssociationFilter
      .wrap(buildAwsValue())
}
object ConnectionGroupAssociationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ConnectionGroupAssociationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ConnectionGroupAssociationFilter =
      zio.aws.cloudfront.model
        .ConnectionGroupAssociationFilter(anycastIpListId.map(value => value))
    def anycastIpListId: Optional[String]
    def getAnycastIpListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("anycastIpListId", anycastIpListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ConnectionGroupAssociationFilter
  ) extends zio.aws.cloudfront.model.ConnectionGroupAssociationFilter.ReadOnly {
    override val anycastIpListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.anycastIpListId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ConnectionGroupAssociationFilter
  ): zio.aws.cloudfront.model.ConnectionGroupAssociationFilter.ReadOnly =
    new Wrapper(impl)
}
