package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateDistributionTenantWebAclResponse(
    id: Optional[String] = Optional.Absent,
    webACLArn: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.AssociateDistributionTenantWebAclResponse = {
    import AssociateDistributionTenantWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.AssociateDistributionTenantWebAclResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(webACLArn.map(value => value: java.lang.String))(
        _.webACLArn
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.AssociateDistributionTenantWebAclResponse.ReadOnly =
    zio.aws.cloudfront.model.AssociateDistributionTenantWebAclResponse
      .wrap(buildAwsValue())
}
object AssociateDistributionTenantWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.AssociateDistributionTenantWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.AssociateDistributionTenantWebAclResponse =
      zio.aws.cloudfront.model.AssociateDistributionTenantWebAclResponse(
        id.map(value => value),
        webACLArn.map(value => value),
        eTag.map(value => value)
      )
    def id: Optional[String]
    def webACLArn: Optional[String]
    def eTag: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getWebACLArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("webACLArn", webACLArn)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.AssociateDistributionTenantWebAclResponse
  ) extends zio.aws.cloudfront.model.AssociateDistributionTenantWebAclResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val webACLArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.webACLArn())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.AssociateDistributionTenantWebAclResponse
  ): zio.aws.cloudfront.model.AssociateDistributionTenantWebAclResponse.ReadOnly =
    new Wrapper(impl)
}
