package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.OriginShieldRegion
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OriginShield(
    enabled: Boolean,
    originShieldRegion: Optional[OriginShieldRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginShield = {
    import OriginShield.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginShield
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        originShieldRegion.map(value =>
          OriginShieldRegion.unwrap(value): java.lang.String
        )
      )(_.originShieldRegion)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginShield.ReadOnly =
    zio.aws.cloudfront.model.OriginShield.wrap(buildAwsValue())
}
object OriginShield {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginShield
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginShield =
      zio.aws.cloudfront.model
        .OriginShield(enabled, originShieldRegion.map(value => value))
    def enabled: Boolean
    def originShieldRegion: Optional[OriginShieldRegion]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getOriginShieldRegion: ZIO[Any, AwsError, OriginShieldRegion] =
      AwsError.unwrapOptionField("originShieldRegion", originShieldRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginShield
  ) extends zio.aws.cloudfront.model.OriginShield.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val originShieldRegion: Optional[OriginShieldRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originShieldRegion())
        .map(value =>
          zio.aws.cloudfront.model.primitives.OriginShieldRegion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginShield
  ): zio.aws.cloudfront.model.OriginShield.ReadOnly = new Wrapper(impl)
}
