package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait HttpVersion {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.HttpVersion
}
object HttpVersion {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.HttpVersion
  ): zio.aws.cloudfront.model.HttpVersion = value match {
    case software.amazon.awssdk.services.cloudfront.model.HttpVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.HttpVersion.HTTP1_1 =>
      val r = `http1.1`
      r
    case software.amazon.awssdk.services.cloudfront.model.HttpVersion.HTTP2 =>
      val r = http2
      r
    case software.amazon.awssdk.services.cloudfront.model.HttpVersion.HTTP3 =>
      val r = http3
      r
    case software.amazon.awssdk.services.cloudfront.model.HttpVersion.HTTP2_AND3 =>
      val r = http2and3
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudfront.model.HttpVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.HttpVersion =
      software.amazon.awssdk.services.cloudfront.model.HttpVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object `http1.1` extends zio.aws.cloudfront.model.HttpVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.HttpVersion =
      software.amazon.awssdk.services.cloudfront.model.HttpVersion.HTTP1_1
  }
  case object http2 extends zio.aws.cloudfront.model.HttpVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.HttpVersion =
      software.amazon.awssdk.services.cloudfront.model.HttpVersion.HTTP2
  }
  case object http3 extends zio.aws.cloudfront.model.HttpVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.HttpVersion =
      software.amazon.awssdk.services.cloudfront.model.HttpVersion.HTTP3
  }
  case object http2and3 extends zio.aws.cloudfront.model.HttpVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.HttpVersion =
      software.amazon.awssdk.services.cloudfront.model.HttpVersion.HTTP2_AND3
  }
}
