package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.{
  KeyValueStoreComment,
  KeyValueStoreName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeyValueStoreRequest(
    name: KeyValueStoreName,
    comment: Optional[KeyValueStoreComment] = Optional.Absent,
    importSource: Optional[zio.aws.cloudfront.model.ImportSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreRequest = {
    import CreateKeyValueStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreRequest
      .builder()
      .name(KeyValueStoreName.unwrap(name): java.lang.String)
      .optionallyWith(
        comment.map(value =>
          KeyValueStoreComment.unwrap(value): java.lang.String
        )
      )(_.comment)
      .optionallyWith(importSource.map(value => value.buildAwsValue()))(
        _.importSource
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateKeyValueStoreRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateKeyValueStoreRequest.wrap(buildAwsValue())
}
object CreateKeyValueStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateKeyValueStoreRequest =
      zio.aws.cloudfront.model.CreateKeyValueStoreRequest(
        name,
        comment.map(value => value),
        importSource.map(value => value.asEditable)
      )
    def name: KeyValueStoreName
    def comment: Optional[KeyValueStoreComment]
    def importSource: Optional[zio.aws.cloudfront.model.ImportSource.ReadOnly]
    def getName: ZIO[Any, Nothing, KeyValueStoreName] = ZIO.succeed(name)
    def getComment: ZIO[Any, AwsError, KeyValueStoreComment] =
      AwsError.unwrapOptionField("comment", comment)
    def getImportSource
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.ImportSource.ReadOnly] =
      AwsError.unwrapOptionField("importSource", importSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreRequest
  ) extends zio.aws.cloudfront.model.CreateKeyValueStoreRequest.ReadOnly {
    override val name: KeyValueStoreName =
      zio.aws.cloudfront.model.primitives.KeyValueStoreName(impl.name())
    override val comment: Optional[KeyValueStoreComment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value =>
        zio.aws.cloudfront.model.primitives.KeyValueStoreComment(value)
      )
    override val importSource
        : Optional[zio.aws.cloudfront.model.ImportSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importSource())
        .map(value => zio.aws.cloudfront.model.ImportSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreRequest
  ): zio.aws.cloudfront.model.CreateKeyValueStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
