package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.SensitiveStringType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestResult(
    functionSummary: Optional[zio.aws.cloudfront.model.FunctionSummary] =
      Optional.Absent,
    computeUtilization: Optional[String] = Optional.Absent,
    functionExecutionLogs: Optional[Iterable[String]] = Optional.Absent,
    functionErrorMessage: Optional[SensitiveStringType] = Optional.Absent,
    functionOutput: Optional[SensitiveStringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TestResult = {
    import TestResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TestResult
      .builder()
      .optionallyWith(functionSummary.map(value => value.buildAwsValue()))(
        _.functionSummary
      )
      .optionallyWith(computeUtilization.map(value => value: java.lang.String))(
        _.computeUtilization
      )
      .optionallyWith(
        functionExecutionLogs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.functionExecutionLogs)
      .optionallyWith(
        functionErrorMessage.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.functionErrorMessage)
      .optionallyWith(
        functionOutput.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.functionOutput)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TestResult.ReadOnly =
    zio.aws.cloudfront.model.TestResult.wrap(buildAwsValue())
}
object TestResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TestResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TestResult =
      zio.aws.cloudfront.model.TestResult(
        functionSummary.map(value => value.asEditable),
        computeUtilization.map(value => value),
        functionExecutionLogs.map(value => value),
        functionErrorMessage.map(value => value),
        functionOutput.map(value => value)
      )
    def functionSummary
        : Optional[zio.aws.cloudfront.model.FunctionSummary.ReadOnly]
    def computeUtilization: Optional[String]
    def functionExecutionLogs: Optional[List[String]]
    def functionErrorMessage: Optional[SensitiveStringType]
    def functionOutput: Optional[SensitiveStringType]
    def getFunctionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FunctionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("functionSummary", functionSummary)
    def getComputeUtilization: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("computeUtilization", computeUtilization)
    def getFunctionExecutionLogs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("functionExecutionLogs", functionExecutionLogs)
    def getFunctionErrorMessage: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("functionErrorMessage", functionErrorMessage)
    def getFunctionOutput: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("functionOutput", functionOutput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TestResult
  ) extends zio.aws.cloudfront.model.TestResult.ReadOnly {
    override val functionSummary
        : Optional[zio.aws.cloudfront.model.FunctionSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionSummary())
        .map(value => zio.aws.cloudfront.model.FunctionSummary.wrap(value))
    override val computeUtilization: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.computeUtilization())
      .map(value => value: String)
    override val functionExecutionLogs: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionExecutionLogs())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val functionErrorMessage: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionErrorMessage())
        .map(value =>
          zio.aws.cloudfront.model.primitives.SensitiveStringType(value)
        )
    override val functionOutput: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionOutput())
        .map(value =>
          zio.aws.cloudfront.model.primitives.SensitiveStringType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TestResult
  ): zio.aws.cloudfront.model.TestResult.ReadOnly = new Wrapper(impl)
}
