package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeyValueStoreResponse(
    keyValueStore: Optional[zio.aws.cloudfront.model.KeyValueStore] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent,
    location: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreResponse = {
    import CreateKeyValueStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreResponse
      .builder()
      .optionallyWith(keyValueStore.map(value => value.buildAwsValue()))(
        _.keyValueStore
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateKeyValueStoreResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateKeyValueStoreResponse.wrap(buildAwsValue())
}
object CreateKeyValueStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateKeyValueStoreResponse =
      zio.aws.cloudfront.model.CreateKeyValueStoreResponse(
        keyValueStore.map(value => value.asEditable),
        eTag.map(value => value),
        location.map(value => value)
      )
    def keyValueStore: Optional[zio.aws.cloudfront.model.KeyValueStore.ReadOnly]
    def eTag: Optional[String]
    def location: Optional[String]
    def getKeyValueStore
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.KeyValueStore.ReadOnly] =
      AwsError.unwrapOptionField("keyValueStore", keyValueStore)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreResponse
  ) extends zio.aws.cloudfront.model.CreateKeyValueStoreResponse.ReadOnly {
    override val keyValueStore
        : Optional[zio.aws.cloudfront.model.KeyValueStore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyValueStore())
        .map(value => zio.aws.cloudfront.model.KeyValueStore.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreResponse
  ): zio.aws.cloudfront.model.CreateKeyValueStoreResponse.ReadOnly =
    new Wrapper(impl)
}
