package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OriginGroups(
    quantity: Integer,
    items: Optional[Iterable[zio.aws.cloudfront.model.OriginGroup]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginGroups = {
    import OriginGroups.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginGroups
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginGroups.ReadOnly =
    zio.aws.cloudfront.model.OriginGroups.wrap(buildAwsValue())
}
object OriginGroups {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginGroups
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginGroups =
      zio.aws.cloudfront.model.OriginGroups(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items: Optional[List[zio.aws.cloudfront.model.OriginGroup.ReadOnly]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.OriginGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroups
  ) extends zio.aws.cloudfront.model.OriginGroups.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items
        : Optional[List[zio.aws.cloudfront.model.OriginGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.OriginGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroups
  ): zio.aws.cloudfront.model.OriginGroups.ReadOnly = new Wrapper(impl)
}
