package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAnycastIpListRequest(id: String, ifMatch: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteAnycastIpListRequest = {
    import DeleteAnycastIpListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteAnycastIpListRequest
      .builder()
      .id(id: java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DeleteAnycastIpListRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteAnycastIpListRequest.wrap(buildAwsValue())
}
object DeleteAnycastIpListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteAnycastIpListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteAnycastIpListRequest =
      zio.aws.cloudfront.model.DeleteAnycastIpListRequest(id, ifMatch)
    def id: String
    def ifMatch: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteAnycastIpListRequest
  ) extends zio.aws.cloudfront.model.DeleteAnycastIpListRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteAnycastIpListRequest
  ): zio.aws.cloudfront.model.DeleteAnycastIpListRequest.ReadOnly = new Wrapper(
    impl
  )
}
