package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OriginAccessControl(
    id: String,
    originAccessControlConfig: Optional[
      zio.aws.cloudfront.model.OriginAccessControlConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginAccessControl = {
    import OriginAccessControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginAccessControl
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(
        originAccessControlConfig.map(value => value.buildAwsValue())
      )(_.originAccessControlConfig)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginAccessControl.ReadOnly =
    zio.aws.cloudfront.model.OriginAccessControl.wrap(buildAwsValue())
}
object OriginAccessControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginAccessControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginAccessControl =
      zio.aws.cloudfront.model.OriginAccessControl(
        id,
        originAccessControlConfig.map(value => value.asEditable)
      )
    def id: String
    def originAccessControlConfig
        : Optional[zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getOriginAccessControlConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "originAccessControlConfig",
      originAccessControlConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginAccessControl
  ) extends zio.aws.cloudfront.model.OriginAccessControl.ReadOnly {
    override val id: String = impl.id(): String
    override val originAccessControlConfig: Optional[
      zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.originAccessControlConfig())
      .map(value =>
        zio.aws.cloudfront.model.OriginAccessControlConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginAccessControl
  ): zio.aws.cloudfront.model.OriginAccessControl.ReadOnly = new Wrapper(impl)
}
