package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait OriginAccessControlOriginTypes {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes
}
object OriginAccessControlOriginTypes {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes
  ): zio.aws.cloudfront.model.OriginAccessControlOriginTypes = value match {
    case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.S3 =>
      val r = s3
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.MEDIASTORE =>
      val r = mediastore
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.MEDIAPACKAGEV2 =>
      val r = mediapackagev2
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.LAMBDA =>
      val r = lambda
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.OriginAccessControlOriginTypes {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object s3
      extends zio.aws.cloudfront.model.OriginAccessControlOriginTypes {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.S3
  }
  case object mediastore
      extends zio.aws.cloudfront.model.OriginAccessControlOriginTypes {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.MEDIASTORE
  }
  case object mediapackagev2
      extends zio.aws.cloudfront.model.OriginAccessControlOriginTypes {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.MEDIAPACKAGEV2
  }
  case object lambda
      extends zio.aws.cloudfront.model.OriginAccessControlOriginTypes {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes.LAMBDA
  }
}
