package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInvalidationResponse(
    location: Optional[String] = Optional.Absent,
    invalidation: Optional[zio.aws.cloudfront.model.Invalidation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse = {
    import CreateInvalidationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(invalidation.map(value => value.buildAwsValue()))(
        _.invalidation
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateInvalidationResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateInvalidationResponse.wrap(buildAwsValue())
}
object CreateInvalidationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateInvalidationResponse =
      zio.aws.cloudfront.model.CreateInvalidationResponse(
        location.map(value => value),
        invalidation.map(value => value.asEditable)
      )
    def location: Optional[String]
    def invalidation: Optional[zio.aws.cloudfront.model.Invalidation.ReadOnly]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getInvalidation
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Invalidation.ReadOnly] =
      AwsError.unwrapOptionField("invalidation", invalidation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse
  ) extends zio.aws.cloudfront.model.CreateInvalidationResponse.ReadOnly {
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val invalidation
        : Optional[zio.aws.cloudfront.model.Invalidation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidation())
        .map(value => zio.aws.cloudfront.model.Invalidation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse
  ): zio.aws.cloudfront.model.CreateInvalidationResponse.ReadOnly = new Wrapper(
    impl
  )
}
