package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePublicKeyRequest(
    publicKeyConfig: zio.aws.cloudfront.model.PublicKeyConfig,
    id: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest = {
    import UpdatePublicKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest
      .builder()
      .publicKeyConfig(publicKeyConfig.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdatePublicKeyRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdatePublicKeyRequest.wrap(buildAwsValue())
}
object UpdatePublicKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdatePublicKeyRequest =
      zio.aws.cloudfront.model.UpdatePublicKeyRequest(
        publicKeyConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def publicKeyConfig: zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly
    def id: String
    def ifMatch: Optional[String]
    def getPublicKeyConfig
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly] =
      ZIO.succeed(publicKeyConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest
  ) extends zio.aws.cloudfront.model.UpdatePublicKeyRequest.ReadOnly {
    override val publicKeyConfig
        : zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly =
      zio.aws.cloudfront.model.PublicKeyConfig.wrap(impl.publicKeyConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest
  ): zio.aws.cloudfront.model.UpdatePublicKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
