package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.{Integer, AnycastIpListName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAnycastIpListRequest(
    name: AnycastIpListName,
    ipCount: Integer,
    tags: Optional[zio.aws.cloudfront.model.Tags] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListRequest = {
    import CreateAnycastIpListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListRequest
      .builder()
      .name(AnycastIpListName.unwrap(name): java.lang.String)
      .ipCount(ipCount: java.lang.Integer)
      .optionallyWith(tags.map(value => value.buildAwsValue()))(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateAnycastIpListRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateAnycastIpListRequest.wrap(buildAwsValue())
}
object CreateAnycastIpListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateAnycastIpListRequest =
      zio.aws.cloudfront.model.CreateAnycastIpListRequest(
        name,
        ipCount,
        tags.map(value => value.asEditable)
      )
    def name: AnycastIpListName
    def ipCount: Integer
    def tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly]
    def getName: ZIO[Any, Nothing, AnycastIpListName] = ZIO.succeed(name)
    def getIpCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(ipCount)
    def getTags: ZIO[Any, AwsError, zio.aws.cloudfront.model.Tags.ReadOnly] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListRequest
  ) extends zio.aws.cloudfront.model.CreateAnycastIpListRequest.ReadOnly {
    override val name: AnycastIpListName =
      zio.aws.cloudfront.model.primitives.AnycastIpListName(impl.name())
    override val ipCount: Integer = impl.ipCount(): Integer
    override val tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value => zio.aws.cloudfront.model.Tags.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListRequest
  ): zio.aws.cloudfront.model.CreateAnycastIpListRequest.ReadOnly = new Wrapper(
    impl
  )
}
