package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FunctionMetadata(
    functionARN: String,
    stage: Optional[zio.aws.cloudfront.model.FunctionStage] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FunctionMetadata = {
    import FunctionMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FunctionMetadata
      .builder()
      .functionARN(functionARN: java.lang.String)
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.FunctionMetadata.ReadOnly =
    zio.aws.cloudfront.model.FunctionMetadata.wrap(buildAwsValue())
}
object FunctionMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FunctionMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FunctionMetadata =
      zio.aws.cloudfront.model.FunctionMetadata(
        functionARN,
        stage.map(value => value),
        createdTime.map(value => value),
        lastModifiedTime
      )
    def functionARN: String
    def stage: Optional[zio.aws.cloudfront.model.FunctionStage]
    def createdTime: Optional[Timestamp]
    def lastModifiedTime: Timestamp
    def getFunctionARN: ZIO[Any, Nothing, String] = ZIO.succeed(functionARN)
    def getStage: ZIO[Any, AwsError, zio.aws.cloudfront.model.FunctionStage] =
      AwsError.unwrapOptionField("stage", stage)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionMetadata
  ) extends zio.aws.cloudfront.model.FunctionMetadata.ReadOnly {
    override val functionARN: String = impl.functionARN(): String
    override val stage: Optional[zio.aws.cloudfront.model.FunctionStage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.cloudfront.model.FunctionStage.wrap(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.cloudfront.model.primitives.Timestamp(value))
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionMetadata
  ): zio.aws.cloudfront.model.FunctionMetadata.ReadOnly = new Wrapper(impl)
}
