package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class VpcOrigin(
    id: String,
    arn: String,
    status: String,
    createdTime: Timestamp,
    lastModifiedTime: Timestamp,
    vpcOriginEndpointConfig: zio.aws.cloudfront.model.VpcOriginEndpointConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.VpcOrigin = {
    import VpcOrigin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.VpcOrigin
      .builder()
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .status(status: java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .vpcOriginEndpointConfig(vpcOriginEndpointConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.VpcOrigin.ReadOnly =
    zio.aws.cloudfront.model.VpcOrigin.wrap(buildAwsValue())
}
object VpcOrigin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.VpcOrigin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.VpcOrigin =
      zio.aws.cloudfront.model.VpcOrigin(
        id,
        arn,
        status,
        createdTime,
        lastModifiedTime,
        vpcOriginEndpointConfig.asEditable
      )
    def id: String
    def arn: String
    def status: String
    def createdTime: Timestamp
    def lastModifiedTime: Timestamp
    def vpcOriginEndpointConfig
        : zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getVpcOriginEndpointConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly
    ] = ZIO.succeed(vpcOriginEndpointConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.VpcOrigin
  ) extends zio.aws.cloudfront.model.VpcOrigin.ReadOnly {
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val status: String = impl.status(): String
    override val createdTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.createdTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val vpcOriginEndpointConfig
        : zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly =
      zio.aws.cloudfront.model.VpcOriginEndpointConfig
        .wrap(impl.vpcOriginEndpointConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.VpcOrigin
  ): zio.aws.cloudfront.model.VpcOrigin.ReadOnly = new Wrapper(impl)
}
