package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVpcOriginsResponse(
    vpcOriginList: Optional[zio.aws.cloudfront.model.VpcOriginList] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListVpcOriginsResponse = {
    import ListVpcOriginsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListVpcOriginsResponse
      .builder()
      .optionallyWith(vpcOriginList.map(value => value.buildAwsValue()))(
        _.vpcOriginList
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListVpcOriginsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListVpcOriginsResponse.wrap(buildAwsValue())
}
object ListVpcOriginsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListVpcOriginsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListVpcOriginsResponse =
      zio.aws.cloudfront.model
        .ListVpcOriginsResponse(vpcOriginList.map(value => value.asEditable))
    def vpcOriginList: Optional[zio.aws.cloudfront.model.VpcOriginList.ReadOnly]
    def getVpcOriginList
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.VpcOriginList.ReadOnly] =
      AwsError.unwrapOptionField("vpcOriginList", vpcOriginList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListVpcOriginsResponse
  ) extends zio.aws.cloudfront.model.ListVpcOriginsResponse.ReadOnly {
    override val vpcOriginList
        : Optional[zio.aws.cloudfront.model.VpcOriginList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOriginList())
        .map(value => zio.aws.cloudfront.model.VpcOriginList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListVpcOriginsResponse
  ): zio.aws.cloudfront.model.ListVpcOriginsResponse.ReadOnly = new Wrapper(
    impl
  )
}
