package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KeyGroupConfig(
    name: String,
    items: Iterable[String],
    comment: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.KeyGroupConfig = {
    import KeyGroupConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.KeyGroupConfig
      .builder()
      .name(name: java.lang.String)
      .items(items.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly =
    zio.aws.cloudfront.model.KeyGroupConfig.wrap(buildAwsValue())
}
object KeyGroupConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.KeyGroupConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.KeyGroupConfig =
      zio.aws.cloudfront.model
        .KeyGroupConfig(name, items, comment.map(value => value))
    def name: String
    def items: List[String]
    def comment: Optional[String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getItems: ZIO[Any, Nothing, List[String]] = ZIO.succeed(items)
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyGroupConfig
  ) extends zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly {
    override val name: String = impl.name(): String
    override val items: List[String] = impl
      .items()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyGroupConfig
  ): zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly = new Wrapper(impl)
}
