package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.KeyValueStoreName
import scala.jdk.CollectionConverters._
final case class DescribeKeyValueStoreRequest(name: KeyValueStoreName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreRequest = {
    import DescribeKeyValueStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreRequest
      .builder()
      .name(KeyValueStoreName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DescribeKeyValueStoreRequest.ReadOnly =
    zio.aws.cloudfront.model.DescribeKeyValueStoreRequest.wrap(buildAwsValue())
}
object DescribeKeyValueStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DescribeKeyValueStoreRequest =
      zio.aws.cloudfront.model.DescribeKeyValueStoreRequest(name)
    def name: KeyValueStoreName
    def getName: ZIO[Any, Nothing, KeyValueStoreName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreRequest
  ) extends zio.aws.cloudfront.model.DescribeKeyValueStoreRequest.ReadOnly {
    override val name: KeyValueStoreName =
      zio.aws.cloudfront.model.primitives.KeyValueStoreName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreRequest
  ): zio.aws.cloudfront.model.DescribeKeyValueStoreRequest.ReadOnly =
    new Wrapper(impl)
}
