package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateVpcOriginResponse(
    vpcOrigin: Optional[zio.aws.cloudfront.model.VpcOrigin] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginResponse = {
    import UpdateVpcOriginResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginResponse
      .builder()
      .optionallyWith(vpcOrigin.map(value => value.buildAwsValue()))(
        _.vpcOrigin
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateVpcOriginResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateVpcOriginResponse.wrap(buildAwsValue())
}
object UpdateVpcOriginResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateVpcOriginResponse =
      zio.aws.cloudfront.model.UpdateVpcOriginResponse(
        vpcOrigin.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def vpcOrigin: Optional[zio.aws.cloudfront.model.VpcOrigin.ReadOnly]
    def eTag: Optional[String]
    def getVpcOrigin
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.VpcOrigin.ReadOnly] =
      AwsError.unwrapOptionField("vpcOrigin", vpcOrigin)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginResponse
  ) extends zio.aws.cloudfront.model.UpdateVpcOriginResponse.ReadOnly {
    override val vpcOrigin
        : Optional[zio.aws.cloudfront.model.VpcOrigin.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOrigin())
        .map(value => zio.aws.cloudfront.model.VpcOrigin.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginResponse
  ): zio.aws.cloudfront.model.UpdateVpcOriginResponse.ReadOnly = new Wrapper(
    impl
  )
}
