package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait OriginAccessControlSigningProtocols {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningProtocols
}
object OriginAccessControlSigningProtocols {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningProtocols
  ): zio.aws.cloudfront.model.OriginAccessControlSigningProtocols =
    value match {
      case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningProtocols.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningProtocols.SIGV4 =>
        val r = sigv4
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.OriginAccessControlSigningProtocols {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningProtocols =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningProtocols.UNKNOWN_TO_SDK_VERSION
  }
  case object sigv4
      extends zio.aws.cloudfront.model.OriginAccessControlSigningProtocols {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningProtocols =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningProtocols.SIGV4
  }
}
