package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudFrontOriginAccessIdentitySummary(
    id: String,
    s3CanonicalUserId: String,
    comment: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary = {
    import CloudFrontOriginAccessIdentitySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary
      .builder()
      .id(id: java.lang.String)
      .s3CanonicalUserId(s3CanonicalUserId: java.lang.String)
      .comment(comment: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary.ReadOnly =
    zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary
      .wrap(buildAwsValue())
}
object CloudFrontOriginAccessIdentitySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary =
      zio.aws.cloudfront.model
        .CloudFrontOriginAccessIdentitySummary(id, s3CanonicalUserId, comment)
    def id: String
    def s3CanonicalUserId: String
    def comment: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getS3CanonicalUserId: ZIO[Any, Nothing, String] =
      ZIO.succeed(s3CanonicalUserId)
    def getComment: ZIO[Any, Nothing, String] = ZIO.succeed(comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary
  ) extends zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary.ReadOnly {
    override val id: String = impl.id(): String
    override val s3CanonicalUserId: String = impl.s3CanonicalUserId(): String
    override val comment: String = impl.comment(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary
  ): zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary.ReadOnly =
    new Wrapper(impl)
}
