package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QueryArgProfiles(
    quantity: Integer,
    items: Optional[Iterable[zio.aws.cloudfront.model.QueryArgProfile]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.QueryArgProfiles = {
    import QueryArgProfiles.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.QueryArgProfiles
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.QueryArgProfiles.ReadOnly =
    zio.aws.cloudfront.model.QueryArgProfiles.wrap(buildAwsValue())
}
object QueryArgProfiles {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.QueryArgProfiles
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.QueryArgProfiles =
      zio.aws.cloudfront.model.QueryArgProfiles(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items: Optional[List[zio.aws.cloudfront.model.QueryArgProfile.ReadOnly]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.QueryArgProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.QueryArgProfiles
  ) extends zio.aws.cloudfront.model.QueryArgProfiles.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items
        : Optional[List[zio.aws.cloudfront.model.QueryArgProfile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.QueryArgProfile.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.QueryArgProfiles
  ): zio.aws.cloudfront.model.QueryArgProfiles.ReadOnly = new Wrapper(impl)
}
