package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StreamingDistribution(
    id: String,
    arn: String,
    status: String,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    domainName: String,
    activeTrustedSigners: zio.aws.cloudfront.model.ActiveTrustedSigners,
    streamingDistributionConfig: zio.aws.cloudfront.model.StreamingDistributionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.StreamingDistribution = {
    import StreamingDistribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.StreamingDistribution
      .builder()
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .status(status: java.lang.String)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .domainName(domainName: java.lang.String)
      .activeTrustedSigners(activeTrustedSigners.buildAwsValue())
      .streamingDistributionConfig(streamingDistributionConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.StreamingDistribution.ReadOnly =
    zio.aws.cloudfront.model.StreamingDistribution.wrap(buildAwsValue())
}
object StreamingDistribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.StreamingDistribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.StreamingDistribution =
      zio.aws.cloudfront.model.StreamingDistribution(
        id,
        arn,
        status,
        lastModifiedTime.map(value => value),
        domainName,
        activeTrustedSigners.asEditable,
        streamingDistributionConfig.asEditable
      )
    def id: String
    def arn: String
    def status: String
    def lastModifiedTime: Optional[Timestamp]
    def domainName: String
    def activeTrustedSigners
        : zio.aws.cloudfront.model.ActiveTrustedSigners.ReadOnly
    def streamingDistributionConfig
        : zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getActiveTrustedSigners: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ActiveTrustedSigners.ReadOnly
    ] = ZIO.succeed(activeTrustedSigners)
    def getStreamingDistributionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    ] = ZIO.succeed(streamingDistributionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingDistribution
  ) extends zio.aws.cloudfront.model.StreamingDistribution.ReadOnly {
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val status: String = impl.status(): String
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.cloudfront.model.primitives.Timestamp(value))
    override val domainName: String = impl.domainName(): String
    override val activeTrustedSigners
        : zio.aws.cloudfront.model.ActiveTrustedSigners.ReadOnly =
      zio.aws.cloudfront.model.ActiveTrustedSigners
        .wrap(impl.activeTrustedSigners())
    override val streamingDistributionConfig
        : zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly =
      zio.aws.cloudfront.model.StreamingDistributionConfig
        .wrap(impl.streamingDistributionConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingDistribution
  ): zio.aws.cloudfront.model.StreamingDistribution.ReadOnly = new Wrapper(impl)
}
