package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DistributionConfigWithTags(
    distributionConfig: zio.aws.cloudfront.model.DistributionConfig,
    tags: zio.aws.cloudfront.model.Tags
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DistributionConfigWithTags = {
    import DistributionConfigWithTags.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DistributionConfigWithTags
      .builder()
      .distributionConfig(distributionConfig.buildAwsValue())
      .tags(tags.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DistributionConfigWithTags.ReadOnly =
    zio.aws.cloudfront.model.DistributionConfigWithTags.wrap(buildAwsValue())
}
object DistributionConfigWithTags {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DistributionConfigWithTags
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DistributionConfigWithTags =
      zio.aws.cloudfront.model.DistributionConfigWithTags(
        distributionConfig.asEditable,
        tags.asEditable
      )
    def distributionConfig: zio.aws.cloudfront.model.DistributionConfig.ReadOnly
    def tags: zio.aws.cloudfront.model.Tags.ReadOnly
    def getDistributionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.DistributionConfig.ReadOnly
    ] = ZIO.succeed(distributionConfig)
    def getTags: ZIO[Any, Nothing, zio.aws.cloudfront.model.Tags.ReadOnly] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionConfigWithTags
  ) extends zio.aws.cloudfront.model.DistributionConfigWithTags.ReadOnly {
    override val distributionConfig
        : zio.aws.cloudfront.model.DistributionConfig.ReadOnly =
      zio.aws.cloudfront.model.DistributionConfig
        .wrap(impl.distributionConfig())
    override val tags: zio.aws.cloudfront.model.Tags.ReadOnly =
      zio.aws.cloudfront.model.Tags.wrap(impl.tags())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionConfigWithTags
  ): zio.aws.cloudfront.model.DistributionConfigWithTags.ReadOnly = new Wrapper(
    impl
  )
}
