package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyConfig(
    comment: Optional[String] = Optional.Absent,
    name: String,
    corsConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig
    ] = Optional.Absent,
    securityHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig
    ] = Optional.Absent,
    serverTimingHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig
    ] = Optional.Absent,
    customHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig
    ] = Optional.Absent,
    removeHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig = {
    import ResponseHeadersPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig
      .builder()
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .name(name: java.lang.String)
      .optionallyWith(corsConfig.map(value => value.buildAwsValue()))(
        _.corsConfig
      )
      .optionallyWith(
        securityHeadersConfig.map(value => value.buildAwsValue())
      )(_.securityHeadersConfig)
      .optionallyWith(
        serverTimingHeadersConfig.map(value => value.buildAwsValue())
      )(_.serverTimingHeadersConfig)
      .optionallyWith(customHeadersConfig.map(value => value.buildAwsValue()))(
        _.customHeadersConfig
      )
      .optionallyWith(removeHeadersConfig.map(value => value.buildAwsValue()))(
        _.removeHeadersConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.wrap(buildAwsValue())
}
object ResponseHeadersPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ResponseHeadersPolicyConfig =
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig(
        comment.map(value => value),
        name,
        corsConfig.map(value => value.asEditable),
        securityHeadersConfig.map(value => value.asEditable),
        serverTimingHeadersConfig.map(value => value.asEditable),
        customHeadersConfig.map(value => value.asEditable),
        removeHeadersConfig.map(value => value.asEditable)
      )
    def comment: Optional[String]
    def name: String
    def corsConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.ReadOnly
    ]
    def securityHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.ReadOnly
    ]
    def serverTimingHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig.ReadOnly
    ]
    def customHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.ReadOnly
    ]
    def removeHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig.ReadOnly
    ]
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getCorsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.ReadOnly
    ] = AwsError.unwrapOptionField("corsConfig", corsConfig)
    def getSecurityHeadersConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("securityHeadersConfig", securityHeadersConfig)
    def getServerTimingHeadersConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverTimingHeadersConfig",
      serverTimingHeadersConfig
    )
    def getCustomHeadersConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.ReadOnly
    ] = AwsError.unwrapOptionField("customHeadersConfig", customHeadersConfig)
    def getRemoveHeadersConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig.ReadOnly
    ] = AwsError.unwrapOptionField("removeHeadersConfig", removeHeadersConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly {
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
    override val name: String = impl.name(): String
    override val corsConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.corsConfig())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyCorsConfig.wrap(value)
      )
    override val securityHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityHeadersConfig())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig
          .wrap(value)
      )
    override val serverTimingHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverTimingHeadersConfig())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig
          .wrap(value)
      )
    override val customHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customHeadersConfig())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig
          .wrap(value)
      )
    override val removeHeadersConfig: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.removeHeadersConfig())
      .map(value =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly =
    new Wrapper(impl)
}
