package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ICPRecordalStatus {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus
}
object ICPRecordalStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus
  ): zio.aws.cloudfront.model.ICPRecordalStatus = value match {
    case software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus.APPROVED =>
      val r = APPROVED
      r
    case software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ICPRecordalStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus =
      software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object APPROVED extends zio.aws.cloudfront.model.ICPRecordalStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus =
      software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus.APPROVED
  }
  case object SUSPENDED extends zio.aws.cloudfront.model.ICPRecordalStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus =
      software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus.SUSPENDED
  }
  case object PENDING extends zio.aws.cloudfront.model.ICPRecordalStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus =
      software.amazon.awssdk.services.cloudfront.model.ICPRecordalStatus.PENDING
  }
}
