package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConflictingAlias(
    alias: Optional[String] = Optional.Absent,
    distributionId: Optional[String] = Optional.Absent,
    accountId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ConflictingAlias = {
    import ConflictingAlias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ConflictingAlias
      .builder()
      .optionallyWith(alias.map(value => value: java.lang.String))(_.alias)
      .optionallyWith(distributionId.map(value => value: java.lang.String))(
        _.distributionId
      )
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ConflictingAlias.ReadOnly =
    zio.aws.cloudfront.model.ConflictingAlias.wrap(buildAwsValue())
}
object ConflictingAlias {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ConflictingAlias
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ConflictingAlias =
      zio.aws.cloudfront.model.ConflictingAlias(
        alias.map(value => value),
        distributionId.map(value => value),
        accountId.map(value => value)
      )
    def alias: Optional[String]
    def distributionId: Optional[String]
    def accountId: Optional[String]
    def getAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("alias", alias)
    def getDistributionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("distributionId", distributionId)
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ConflictingAlias
  ) extends zio.aws.cloudfront.model.ConflictingAlias.ReadOnly {
    override val alias: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => value: String)
    override val distributionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionId())
      .map(value => value: String)
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ConflictingAlias
  ): zio.aws.cloudfront.model.ConflictingAlias.ReadOnly = new Wrapper(impl)
}
