package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OriginAccessControlSummary(
    id: String,
    description: String,
    name: String,
    signingProtocol: zio.aws.cloudfront.model.OriginAccessControlSigningProtocols,
    signingBehavior: zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors,
    originAccessControlOriginType: zio.aws.cloudfront.model.OriginAccessControlOriginTypes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSummary = {
    import OriginAccessControlSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSummary
      .builder()
      .id(id: java.lang.String)
      .description(description: java.lang.String)
      .name(name: java.lang.String)
      .signingProtocol(signingProtocol.unwrap)
      .signingBehavior(signingBehavior.unwrap)
      .originAccessControlOriginType(originAccessControlOriginType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginAccessControlSummary.ReadOnly =
    zio.aws.cloudfront.model.OriginAccessControlSummary.wrap(buildAwsValue())
}
object OriginAccessControlSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginAccessControlSummary =
      zio.aws.cloudfront.model.OriginAccessControlSummary(
        id,
        description,
        name,
        signingProtocol,
        signingBehavior,
        originAccessControlOriginType
      )
    def id: String
    def description: String
    def name: String
    def signingProtocol
        : zio.aws.cloudfront.model.OriginAccessControlSigningProtocols
    def signingBehavior
        : zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors
    def originAccessControlOriginType
        : zio.aws.cloudfront.model.OriginAccessControlOriginTypes
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getSigningProtocol: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginAccessControlSigningProtocols
    ] = ZIO.succeed(signingProtocol)
    def getSigningBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors
    ] = ZIO.succeed(signingBehavior)
    def getOriginAccessControlOriginType: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginAccessControlOriginTypes
    ] = ZIO.succeed(originAccessControlOriginType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSummary
  ) extends zio.aws.cloudfront.model.OriginAccessControlSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val description: String = impl.description(): String
    override val name: String = impl.name(): String
    override val signingProtocol
        : zio.aws.cloudfront.model.OriginAccessControlSigningProtocols =
      zio.aws.cloudfront.model.OriginAccessControlSigningProtocols
        .wrap(impl.signingProtocol())
    override val signingBehavior
        : zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors =
      zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors
        .wrap(impl.signingBehavior())
    override val originAccessControlOriginType
        : zio.aws.cloudfront.model.OriginAccessControlOriginTypes =
      zio.aws.cloudfront.model.OriginAccessControlOriginTypes
        .wrap(impl.originAccessControlOriginType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSummary
  ): zio.aws.cloudfront.model.OriginAccessControlSummary.ReadOnly = new Wrapper(
    impl
  )
}
