package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FunctionConfig(
    comment: String,
    runtime: zio.aws.cloudfront.model.FunctionRuntime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FunctionConfig = {
    import FunctionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FunctionConfig
      .builder()
      .comment(comment: java.lang.String)
      .runtime(runtime.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.FunctionConfig.ReadOnly =
    zio.aws.cloudfront.model.FunctionConfig.wrap(buildAwsValue())
}
object FunctionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FunctionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FunctionConfig =
      zio.aws.cloudfront.model.FunctionConfig(comment, runtime)
    def comment: String
    def runtime: zio.aws.cloudfront.model.FunctionRuntime
    def getComment: ZIO[Any, Nothing, String] = ZIO.succeed(comment)
    def getRuntime
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.FunctionRuntime] =
      ZIO.succeed(runtime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionConfig
  ) extends zio.aws.cloudfront.model.FunctionConfig.ReadOnly {
    override val comment: String = impl.comment(): String
    override val runtime: zio.aws.cloudfront.model.FunctionRuntime =
      zio.aws.cloudfront.model.FunctionRuntime.wrap(impl.runtime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionConfig
  ): zio.aws.cloudfront.model.FunctionConfig.ReadOnly = new Wrapper(impl)
}
