package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait OriginRequestPolicyCookieBehavior {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior
}
object OriginRequestPolicyCookieBehavior {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior
  ): zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior = value match {
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.WHITELIST =>
      val r = whitelist
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.ALL =>
      val r = all
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.ALL_EXCEPT =>
      val r = allExcept
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object none
      extends zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.NONE
  }
  case object whitelist
      extends zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.WHITELIST
  }
  case object all
      extends zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.ALL
  }
  case object allExcept
      extends zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookieBehavior.ALL_EXCEPT
  }
}
