package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.FunctionName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FunctionSummary(
    name: FunctionName,
    status: Optional[String] = Optional.Absent,
    functionConfig: zio.aws.cloudfront.model.FunctionConfig,
    functionMetadata: zio.aws.cloudfront.model.FunctionMetadata
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FunctionSummary = {
    import FunctionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FunctionSummary
      .builder()
      .name(FunctionName.unwrap(name): java.lang.String)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .functionConfig(functionConfig.buildAwsValue())
      .functionMetadata(functionMetadata.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.FunctionSummary.ReadOnly =
    zio.aws.cloudfront.model.FunctionSummary.wrap(buildAwsValue())
}
object FunctionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FunctionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FunctionSummary =
      zio.aws.cloudfront.model.FunctionSummary(
        name,
        status.map(value => value),
        functionConfig.asEditable,
        functionMetadata.asEditable
      )
    def name: FunctionName
    def status: Optional[String]
    def functionConfig: zio.aws.cloudfront.model.FunctionConfig.ReadOnly
    def functionMetadata: zio.aws.cloudfront.model.FunctionMetadata.ReadOnly
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFunctionConfig
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.FunctionConfig.ReadOnly] =
      ZIO.succeed(functionConfig)
    def getFunctionMetadata: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.FunctionMetadata.ReadOnly
    ] = ZIO.succeed(functionMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionSummary
  ) extends zio.aws.cloudfront.model.FunctionSummary.ReadOnly {
    override val name: FunctionName =
      zio.aws.cloudfront.model.primitives.FunctionName(impl.name())
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val functionConfig
        : zio.aws.cloudfront.model.FunctionConfig.ReadOnly =
      zio.aws.cloudfront.model.FunctionConfig.wrap(impl.functionConfig())
    override val functionMetadata
        : zio.aws.cloudfront.model.FunctionMetadata.ReadOnly =
      zio.aws.cloudfront.model.FunctionMetadata.wrap(impl.functionMetadata())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionSummary
  ): zio.aws.cloudfront.model.FunctionSummary.ReadOnly = new Wrapper(impl)
}
