package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RealtimeLogConfig(
    arn: String,
    name: String,
    samplingRate: Long,
    endPoints: Iterable[zio.aws.cloudfront.model.EndPoint],
    fields: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfig = {
    import RealtimeLogConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfig
      .builder()
      .arn(arn: java.lang.String)
      .name(name: java.lang.String)
      .samplingRate(samplingRate: java.lang.Long)
      .endPoints(endPoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .fields(fields.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly =
    zio.aws.cloudfront.model.RealtimeLogConfig.wrap(buildAwsValue())
}
object RealtimeLogConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.RealtimeLogConfig =
      zio.aws.cloudfront.model.RealtimeLogConfig(
        arn,
        name,
        samplingRate,
        endPoints.map { item =>
          item.asEditable
        },
        fields
      )
    def arn: String
    def name: String
    def samplingRate: Long
    def endPoints: List[zio.aws.cloudfront.model.EndPoint.ReadOnly]
    def fields: List[String]
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getSamplingRate: ZIO[Any, Nothing, Long] = ZIO.succeed(samplingRate)
    def getEndPoints
        : ZIO[Any, Nothing, List[zio.aws.cloudfront.model.EndPoint.ReadOnly]] =
      ZIO.succeed(endPoints)
    def getFields: ZIO[Any, Nothing, List[String]] = ZIO.succeed(fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfig
  ) extends zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly {
    override val arn: String = impl.arn(): String
    override val name: String = impl.name(): String
    override val samplingRate: Long = impl.samplingRate(): Long
    override val endPoints: List[zio.aws.cloudfront.model.EndPoint.ReadOnly] =
      impl
        .endPoints()
        .asScala
        .map { item =>
          zio.aws.cloudfront.model.EndPoint.wrap(item)
        }
        .toList
    override val fields: List[String] = impl
      .fields()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfig
  ): zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly = new Wrapper(impl)
}
