package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EndPoint(
    streamType: String,
    kinesisStreamConfig: Optional[
      zio.aws.cloudfront.model.KinesisStreamConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.EndPoint = {
    import EndPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.EndPoint
      .builder()
      .streamType(streamType: java.lang.String)
      .optionallyWith(kinesisStreamConfig.map(value => value.buildAwsValue()))(
        _.kinesisStreamConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.EndPoint.ReadOnly =
    zio.aws.cloudfront.model.EndPoint.wrap(buildAwsValue())
}
object EndPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.EndPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.EndPoint = zio.aws.cloudfront.model
      .EndPoint(streamType, kinesisStreamConfig.map(value => value.asEditable))
    def streamType: String
    def kinesisStreamConfig
        : Optional[zio.aws.cloudfront.model.KinesisStreamConfig.ReadOnly]
    def getStreamType: ZIO[Any, Nothing, String] = ZIO.succeed(streamType)
    def getKinesisStreamConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.KinesisStreamConfig.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisStreamConfig", kinesisStreamConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.EndPoint
  ) extends zio.aws.cloudfront.model.EndPoint.ReadOnly {
    override val streamType: String = impl.streamType(): String
    override val kinesisStreamConfig
        : Optional[zio.aws.cloudfront.model.KinesisStreamConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisStreamConfig())
        .map(value => zio.aws.cloudfront.model.KinesisStreamConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.EndPoint
  ): zio.aws.cloudfront.model.EndPoint.ReadOnly = new Wrapper(impl)
}
