package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateContinuousDeploymentPolicyResponse(
    continuousDeploymentPolicy: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicy
    ] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse = {
    import CreateContinuousDeploymentPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse
      .builder()
      .optionallyWith(
        continuousDeploymentPolicy.map(value => value.buildAwsValue())
      )(_.continuousDeploymentPolicy)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse
      .wrap(buildAwsValue())
}
object CreateContinuousDeploymentPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse =
      zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse(
        continuousDeploymentPolicy.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def continuousDeploymentPolicy
        : Optional[zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getContinuousDeploymentPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continuousDeploymentPolicy",
      continuousDeploymentPolicy
    )
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse
  ) extends zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse.ReadOnly {
    override val continuousDeploymentPolicy: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.continuousDeploymentPolicy())
      .map(value =>
        zio.aws.cloudfront.model.ContinuousDeploymentPolicy.wrap(value)
      )
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse
  ): zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
