package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPublicKeysResponse(
    publicKeyList: Optional[zio.aws.cloudfront.model.PublicKeyList] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse = {
    import ListPublicKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse
      .builder()
      .optionallyWith(publicKeyList.map(value => value.buildAwsValue()))(
        _.publicKeyList
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListPublicKeysResponse.ReadOnly =
    zio.aws.cloudfront.model.ListPublicKeysResponse.wrap(buildAwsValue())
}
object ListPublicKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListPublicKeysResponse =
      zio.aws.cloudfront.model
        .ListPublicKeysResponse(publicKeyList.map(value => value.asEditable))
    def publicKeyList: Optional[zio.aws.cloudfront.model.PublicKeyList.ReadOnly]
    def getPublicKeyList
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.PublicKeyList.ReadOnly] =
      AwsError.unwrapOptionField("publicKeyList", publicKeyList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse
  ) extends zio.aws.cloudfront.model.ListPublicKeysResponse.ReadOnly {
    override val publicKeyList
        : Optional[zio.aws.cloudfront.model.PublicKeyList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicKeyList())
        .map(value => zio.aws.cloudfront.model.PublicKeyList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse
  ): zio.aws.cloudfront.model.ListPublicKeysResponse.ReadOnly = new Wrapper(
    impl
  )
}
