package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFunctionRequest(name: String, ifMatch: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest = {
    import DeleteFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest
      .builder()
      .name(name: java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DeleteFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteFunctionRequest.wrap(buildAwsValue())
}
object DeleteFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteFunctionRequest =
      zio.aws.cloudfront.model.DeleteFunctionRequest(name, ifMatch)
    def name: String
    def ifMatch: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest
  ) extends zio.aws.cloudfront.model.DeleteFunctionRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest
  ): zio.aws.cloudfront.model.DeleteFunctionRequest.ReadOnly = new Wrapper(impl)
}
