package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ForwardedValues(
    queryString: Boolean,
    cookies: zio.aws.cloudfront.model.CookiePreference,
    headers: Optional[zio.aws.cloudfront.model.Headers] = Optional.Absent,
    queryStringCacheKeys: Optional[
      zio.aws.cloudfront.model.QueryStringCacheKeys
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ForwardedValues = {
    import ForwardedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ForwardedValues
      .builder()
      .queryString(queryString: java.lang.Boolean)
      .cookies(cookies.buildAwsValue())
      .optionallyWith(headers.map(value => value.buildAwsValue()))(_.headers)
      .optionallyWith(queryStringCacheKeys.map(value => value.buildAwsValue()))(
        _.queryStringCacheKeys
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ForwardedValues.ReadOnly =
    zio.aws.cloudfront.model.ForwardedValues.wrap(buildAwsValue())
}
object ForwardedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ForwardedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ForwardedValues =
      zio.aws.cloudfront.model.ForwardedValues(
        queryString,
        cookies.asEditable,
        headers.map(value => value.asEditable),
        queryStringCacheKeys.map(value => value.asEditable)
      )
    def queryString: Boolean
    def cookies: zio.aws.cloudfront.model.CookiePreference.ReadOnly
    def headers: Optional[zio.aws.cloudfront.model.Headers.ReadOnly]
    def queryStringCacheKeys
        : Optional[zio.aws.cloudfront.model.QueryStringCacheKeys.ReadOnly]
    def getQueryString: ZIO[Any, Nothing, Boolean] = ZIO.succeed(queryString)
    def getCookies: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CookiePreference.ReadOnly
    ] = ZIO.succeed(cookies)
    def getHeaders
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Headers.ReadOnly] =
      AwsError.unwrapOptionField("headers", headers)
    def getQueryStringCacheKeys: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.QueryStringCacheKeys.ReadOnly
    ] = AwsError.unwrapOptionField("queryStringCacheKeys", queryStringCacheKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ForwardedValues
  ) extends zio.aws.cloudfront.model.ForwardedValues.ReadOnly {
    override val queryString: Boolean = impl.queryString(): Boolean
    override val cookies: zio.aws.cloudfront.model.CookiePreference.ReadOnly =
      zio.aws.cloudfront.model.CookiePreference.wrap(impl.cookies())
    override val headers: Optional[zio.aws.cloudfront.model.Headers.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headers())
        .map(value => zio.aws.cloudfront.model.Headers.wrap(value))
    override val queryStringCacheKeys
        : Optional[zio.aws.cloudfront.model.QueryStringCacheKeys.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryStringCacheKeys())
        .map(value => zio.aws.cloudfront.model.QueryStringCacheKeys.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ForwardedValues
  ): zio.aws.cloudfront.model.ForwardedValues.ReadOnly = new Wrapper(impl)
}
