package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CachePolicyConfig(
    comment: Optional[String] = Optional.Absent,
    name: String,
    defaultTTL: Optional[Long] = Optional.Absent,
    maxTTL: Optional[Long] = Optional.Absent,
    minTTL: Long,
    parametersInCacheKeyAndForwardedToOrigin: Optional[
      zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CachePolicyConfig = {
    import CachePolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CachePolicyConfig
      .builder()
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .name(name: java.lang.String)
      .optionallyWith(defaultTTL.map(value => value: java.lang.Long))(
        _.defaultTTL
      )
      .optionallyWith(maxTTL.map(value => value: java.lang.Long))(_.maxTTL)
      .minTTL(minTTL: java.lang.Long)
      .optionallyWith(
        parametersInCacheKeyAndForwardedToOrigin.map(value =>
          value.buildAwsValue()
        )
      )(_.parametersInCacheKeyAndForwardedToOrigin)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly =
    zio.aws.cloudfront.model.CachePolicyConfig.wrap(buildAwsValue())
}
object CachePolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CachePolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CachePolicyConfig =
      zio.aws.cloudfront.model.CachePolicyConfig(
        comment.map(value => value),
        name,
        defaultTTL.map(value => value),
        maxTTL.map(value => value),
        minTTL,
        parametersInCacheKeyAndForwardedToOrigin.map(value => value.asEditable)
      )
    def comment: Optional[String]
    def name: String
    def defaultTTL: Optional[Long]
    def maxTTL: Optional[Long]
    def minTTL: Long
    def parametersInCacheKeyAndForwardedToOrigin: Optional[
      zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin.ReadOnly
    ]
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDefaultTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("defaultTTL", defaultTTL)
    def getMaxTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maxTTL", maxTTL)
    def getMinTTL: ZIO[Any, Nothing, Long] = ZIO.succeed(minTTL)
    def getParametersInCacheKeyAndForwardedToOrigin: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parametersInCacheKeyAndForwardedToOrigin",
      parametersInCacheKeyAndForwardedToOrigin
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicyConfig
  ) extends zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly {
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
    override val name: String = impl.name(): String
    override val defaultTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultTTL())
      .map(value => value: Long)
    override val maxTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.maxTTL())
      .map(value => value: Long)
    override val minTTL: Long = impl.minTTL(): Long
    override val parametersInCacheKeyAndForwardedToOrigin: Optional[
      zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parametersInCacheKeyAndForwardedToOrigin())
      .map(value =>
        zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicyConfig
  ): zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly = new Wrapper(impl)
}
