package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait Method {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.Method
}
object Method {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.Method
  ): zio.aws.cloudfront.model.Method = value match {
    case software.amazon.awssdk.services.cloudfront.model.Method.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.Method.GET =>
      val r = GET
      r
    case software.amazon.awssdk.services.cloudfront.model.Method.HEAD =>
      val r = HEAD
      r
    case software.amazon.awssdk.services.cloudfront.model.Method.POST =>
      val r = POST
      r
    case software.amazon.awssdk.services.cloudfront.model.Method.PUT =>
      val r = PUT
      r
    case software.amazon.awssdk.services.cloudfront.model.Method.PATCH =>
      val r = PATCH
      r
    case software.amazon.awssdk.services.cloudfront.model.Method.OPTIONS =>
      val r = OPTIONS
      r
    case software.amazon.awssdk.services.cloudfront.model.Method.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudfront.model.Method {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Method =
      software.amazon.awssdk.services.cloudfront.model.Method.UNKNOWN_TO_SDK_VERSION
  }
  case object GET extends zio.aws.cloudfront.model.Method {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Method =
      software.amazon.awssdk.services.cloudfront.model.Method.GET
  }
  case object HEAD extends zio.aws.cloudfront.model.Method {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Method =
      software.amazon.awssdk.services.cloudfront.model.Method.HEAD
  }
  case object POST extends zio.aws.cloudfront.model.Method {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Method =
      software.amazon.awssdk.services.cloudfront.model.Method.POST
  }
  case object PUT extends zio.aws.cloudfront.model.Method {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Method =
      software.amazon.awssdk.services.cloudfront.model.Method.PUT
  }
  case object PATCH extends zio.aws.cloudfront.model.Method {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Method =
      software.amazon.awssdk.services.cloudfront.model.Method.PATCH
  }
  case object OPTIONS extends zio.aws.cloudfront.model.Method {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Method =
      software.amazon.awssdk.services.cloudfront.model.Method.OPTIONS
  }
  case object DELETE extends zio.aws.cloudfront.model.Method {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Method =
      software.amazon.awssdk.services.cloudfront.model.Method.DELETE
  }
}
